//
//  shaders.h
//  FreeVRPlayer
//
//  Created by alfred visyon on 23/11/15.
//  Copyright © 2015 Visyon. All rights reserved.
//

#ifndef shaders_h
#define shaders_h

#define STRINGIFY(A)  #A

const char* vertexShaderSource = STRINGIFY(
                                     attribute vec4 position;
                                     uniform mat4 modelViewProjectionMatrix;
                                     void main() {
                                         gl_Position = modelViewProjectionMatrix * position;
                                     }
);

const char* fragmentShaderSimpleSource = STRINGIFY(
                                               precision mediump float;
                                               void main() {
                                                   gl_FragColor = vec4(1,0,0,1);
                                               }
);

#endif /* shaders_h */
